  <?php
    /**
    *
    * copyright (c) 2013-2021 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/articolo.php?id=34&alias=linee-guida-per-l%27uso-del-logo-geecom
    */

    // script che mostra gli ultimi articoli, richiamato dal file creaBlog.php del tema 
    $dataOggi = date("Y-m-d H:i");

    $risultatiPerPagina = $datiBlog["articoliPerPagina"];
    $queryNumeroArticoli = "SELECT COUNT(*) FROM geecB_contenuti WHERE tipo LIKE 'articolo' AND mostraNellaHome='si' AND linguaContenuto LIKE '$lingua' AND stato LIKE 'pubblicato' AND id != {$datiBlog["idArticoloInEvidenza"]} AND dataPubblicazione <= '$dataOggi'";
    $risNumArticoli = $geecomDb->eseguiQueryLettura($queryNumeroArticoli);

    $numArticoli = $risNumArticoli->fetch_array(MYSQLI_NUM);
    $impostazioniLingue     = $geecomDb->leggiSingolaRiga("geecB_impostazioniLingue", 1);
    $linguaLetteraMaiuscola = ucfirst($lingua);
    $datiPaginaBlog = $geecomDb->leggiSingolaRiga("geecB_contenuti",$impostazioniLingue["paginaBlog$linguaLetteraMaiuscola"]);
    $paginaDelBlog  = GeneratoreUrl::creaUrlContenuto($datiPaginaBlog, $impostazioni["ottimizzazioneUrl"], $impostazioni["urlSito"]);
    
    if(isset($_GET["pag"])) {
        $limSup = $risultatiPerPagina * $_GET["pag"];
        $limInf = $limSup - $risultatiPerPagina;
        $queryArticoli="SELECT * FROM geecB_contenuti WHERE tipo LIKE 'articolo' AND  mostraNellaHome='si' 
        AND stato LIKE 'pubblicato' 
        AND id != {$datiBlog["idArticoloInEvidenza"]} 
        AND linguaContenuto LIKE '$lingua' 
        AND dataPubblicazione <= '$dataOggi' 
        ORDER BY dataPubblicazione DESC LIMIT $limInf, $risultatiPerPagina";
        $paginaCorrente = $_GET["pag"];
    }
    else {
        $queryArticoli="SELECT * FROM geecB_contenuti WHERE tipo LIKE 'articolo' AND  mostraNellaHome='si' 
        AND stato LIKE 'pubblicato' 
        AND id != {$datiBlog["idArticoloInEvidenza"]} 
        AND linguaContenuto LIKE '$lingua' 
        AND dataPubblicazione <= '$dataOggi' 
        ORDER BY dataPubblicazione DESC LIMIT $risultatiPerPagina";
        $paginaCorrente = 1;
    }
    
    $risArticoli = $geecomDb->eseguiQueryLettura($queryArticoli);

    //contatore di articoli, serve per consentire una diversa struttura tra il primo articolo e gli altri
    $numeroArticolo = 1; 
    echo"<div class=\"row\">";
    while($articolo = $risArticoli->fetch_assoc()) {
        $numeroCommenti = $geecomDb->contaRigheTabella("geecB_commenti",array("idContenuto"=>$articolo["id"]));
        $arrayCategorie = array();
        
        if($articolo["categoria"]!=0) {
            $categoriaPrincipale     = $geecomDb->leggiSingolaRiga("geec_categorie",$articolo["categoria"]);
            $arrayCategorie[$categoriaPrincipale["nome"]] = GeneratoreUrl::creaUrlCategoria($categoriaPrincipale, $impostazioni["ottimizzazioneUrl"],$impostazioni["urlSito"]);
        }
        
        $queryArticoli="SELECT c.* FROM geec_associazioneCategorieContenuti AS ac JOIN geec_categorie AS c ON c.id=ac.idCategoria "
                        . "WHERE ac.idContenuto = {$articolo["id"]}";
        $risCategorie = $geecomDb->eseguiQueryLettura($queryArticoli);
        while($categoria = $risCategorie->fetch_assoc()) {
            $arrayCategorie[$categoria["nome"]] = GeneratoreUrl::creaUrlCategoria($categoria, $impostazioni["ottimizzazioneUrl"],$impostazioni["urlSito"]);
        }
                
        //lo stile artcolo in evidenza si applica solo al primo articolo della home page del sito, quindi controlla
        //che l'utente si trovi li
        if($numeroArticolo == 1 && $paginaCorrente==1) {

            $linkArticolo = GeneratoreUrl::creaUrlContenuto($articolo,$impostazioni["ottimizzazioneUrl"],$impostazioni["urlSito"]);

            //controllo se è stato impostato un articolo in evidenza (sezione impostazioni-> aspetto home)
            if($datiBlog["idArticoloInEvidenza"] != 0) {
                $queryArticoloInEvidenza="SELECT * FROM geecB_contenuti WHERE tipo LIKE 'articolo' AND  id ={$datiBlog["idArticoloInEvidenza"]}";
                $risArticoloInEvidenza = $geecomDb->eseguiQueryLettura($queryArticoloInEvidenza);
                $articoloInEvidenza = $risArticoloInEvidenza->fetch_assoc();
                $linkArticolo = GeneratoreUrl::creaUrlContenuto($articoloInEvidenza,$impostazioni["ottimizzazioneUrl"],$impostazioni["urlSito"]);
            }
            else {
                $articoloInEvidenza = $articolo;
            }

            if($datiBlog["articoloInEvidenza"]=="titolo sovrapposto") {
                StampaContenuti::visualizzazioneTitoloSovrapposto($articoloInEvidenza,$linkArticolo,$arrayCategorie);
            }
            else if($datiBlog["articoloInEvidenza"]=="Compatto") { //visualizzazione compatta, con foto a sinistra e testo a destra
                $data  = date("d/m/Y",strtotime($articoloInEvidenza["dataPubblicazione"]));
                $testo = explode("<!-- leggi tutto -->",$articoloInEvidenza["testo"]);
                StampaContenuti::visualizzazioneCompatta($gestoreTraduzioni,$articoloInEvidenza, $datiBlog["aspettoImmagineInEvidenzaArticolo"], $linkArticolo, strip_tags($testo[0]),$data,$arrayCategorie,$numeroCommenti,"col-12");
            }
            else if($datiBlog["articoloInEvidenza"]=="Compatto, 2 per riga") { //visualizzazione compatta, 2 per riga
                $data  = date("d/m/Y",strtotime($articoloInEvidenza["dataPubblicazione"]));
                StampaContenuti::articoliAffiancati($gestoreTraduzioni,$articoloInEvidenza, $datiBlog["aspettoImmagineInEvidenzaArticolo"], $linkArticolo, $arrayCategorie, "col-md-6","si");
            }
            else {
                $testo = explode("<!-- leggi tutto -->",$articoloInEvidenza["testo"]);
                $dataCreazione = date("d/m/Y",strtotime($articoloInEvidenza["dataCreazione"]));
                StampaContenuti::stampaArticoliSuccessiviAlPrimo($gestoreTraduzioni,$articoloInEvidenza,$datiBlog["articoloInEvidenza"],$datiBlog["aspettoImmagineInEvidenzaArticolo"],$linkArticolo,$impostazioni,$arrayCategorie,$numeroCommenti);
            }

            //se era impostato l'articolo in evidenza bisoggna stampare anche il primo articolo preso dal ciclo normale
            if($datiBlog["idArticoloInEvidenza"] != 0) { //codice che stampa gli articoli successivi al primo, anche quì si può scegliere tra due stili
                $aspetto = $datiBlog["articoliSuccessivi"];
                $linkArticolo = GeneratoreUrl::creaUrlContenuto($articolo,$impostazioni["ottimizzazioneUrl"],$impostazioni["urlSito"]);
                StampaContenuti::stampaArticoliSuccessiviAlPrimo($gestoreTraduzioni,$articolo,$aspetto,$datiBlog["aspettoImmagineInEvidenzaArticolo"],$linkArticolo,$impostazioni,$arrayCategorie,$numeroCommenti);
            }
        }
        else { //codice che stampa gli articoli successivi al primo, anche quì si può scegliere tra due stili
            $aspetto = $datiBlog["articoliSuccessivi"];
            $linkArticolo = GeneratoreUrl::creaUrlContenuto($articolo,$impostazioni["ottimizzazioneUrl"],$impostazioni["urlSito"]);
            StampaContenuti::stampaArticoliSuccessiviAlPrimo($gestoreTraduzioni,$articolo,$aspetto,$datiBlog["aspettoImmagineInEvidenzaArticolo"],$linkArticolo,$impostazioni,$arrayCategorie,$numeroCommenti);
        }
        $numeroArticolo++;
    }
    echo"</div>";
    
    // paginazione
    if($datiBlog["mostraPaginazione"]=="si") {
        if($numArticoli[0]>$risultatiPerPagina) {
        echo"<nav aria-label=\"Paginazione\" class=\"my-2\">
                <ul class=\"pagination justify-content-center\">";
        // due frecce, per andare alla prima pagina. Se si trova alla prima pagina non viene mostrate
        if($paginaCorrente==1) {
            
        }
        else {
            echo"<li class=\"page-item\"><a class=\"page-link\" href=\"$paginaDelBlog&pag=1\"><i class=\"fas fa-angle-double-left fa-xs\"></i></a></li>";
        }
        
        // una freccia, per andare alla pagina precedente. Se si trova alla prima pagina non viene mostrate
        if($paginaCorrente==1) {

        }
        else {
            $prec = $paginaCorrente-1;
            echo"<li class=\"page-item\"><a class=\"page-link\" href=\"$paginaDelBlog&pag=$prec\"><i class=\"fas fa-angle-left fa-xs\"></i></a></li>";
        }
        
        $numeroPagine = ceil($numArticoli[0]/$risultatiPerPagina);
        if($numeroPagine > 5) {
            $limiteInferiore = $paginaCorrente - 2;
            if($limiteInferiore < 1) {
                $limiteInferiore = 1;
            }
            if($paginaCorrente == 1) {
                $limiteSuperiore=5;
            }
            else {						
                $limiteSuperiore = $paginaCorrente + 2;
            }
            if($limiteSuperiore > $numeroPagine) {
                $limiteSuperiore = $numeroPagine;
            }
            if($limiteInferiore > 1) {
                echo"<li class=\"page-item\"><a class=\"page-link\" >...</a></li>";
            }
            for($i=$limiteInferiore;$i<$limiteSuperiore+1;$i++) {
                if($i==$paginaCorrente) {
                    echo"<li class=\"page-item active\"><a class=\"page-link\">$i</a></li>";		
                }
                else {
                    echo"<li class=\"page-item\"><a class=\"page-link\" href=\"$paginaDelBlog&pag=$i\">$i</a></li>";
                }
            }
            if($limiteSuperiore < $numeroPagine) {
                echo"<li class=\"page-item\"><a class=\"page-link\" >...</a></li>";
            }
        }
        else {
            for($i=1;$i<$numeroPagine+1;$i++) {
                if($i==$paginaCorrente) {
                    echo"<li class=\"page-item active\"><a class=\"page-link\" href=\"\">$i</a></li>";				
                }
                else {
                    echo"<li class=\"page-item\"><a class=\"page-link\" href=\"$paginaDelBlog&pag=$i\">$i</a></li>";
                }
            }
        }
        
        // una freccia, per andare all'ultima pagina. Se si trova all'ultima pagina non vengono mostrate
        if($paginaCorrente==$numeroPagine) {
            
        }
        else {
            $succ = $paginaCorrente+1;
            echo"<li class=\"page-item\"><a class=\"page-link\" href=\"$paginaDelBlog&pag=$succ\"><i class=\"fas fa-angle-right fa-xs\"></i></a></li>";
        }
        
        // due frecce, per andare all'ultima pagina. Se si trova all'ultima pagina non vengono mostrate
        if($paginaCorrente==$numeroPagine) {
            
        }
        else {
            $succ = $paginaCorrente+1;
            echo"<li class=\"page-item\"><a class=\"page-link\" href=\"$paginaDelBlog&pag=$numeroPagine\"><i class=\"fas fa-angle-double-right fa-xs\"></i></a></li>";
        }
        echo"</ul>
        </nav>";
        }
    }
